import PubNub from 'pubnub';
import Controller from '@ember/controller';
import { computed, observer } from '@ember/object';
import { oneWay } from '@ember/object/computed';
import { inject as service } from '@ember/service';

export default Controller.extend({

  headData: service(),

  uuid: oneWay('model.client_id'),

  channel: computed('uuid', function () {
    return `tc.${this.uuid}`;
  }),

  client: computed('uuid', function () {
    let { uuid, channel } = this;
    let client = new PubNub({
      publishKey: 'pub-c-0feaf8b0-e8ce-4587-95a6-f4eb03221890',
      subscribeKey: 'sub-c-4cd77d6c-d24e-11e8-b41d-e643bd6bdd68',
      presenceTimeout: 30,
      uuid
    });

    client.addListener({
      message: ({ message: state }) => {
        let display = this.store.push(this.store.normalize('display', state));

        client.setState({
          state,
          uuid,
          channels: [channel]
        });

        // console.log('setState', state);

        this.setProperties({ display })
      }
    });

    client.subscribe({
      withPresence: true,
      channels: [
        channel
      ]
    });

    client.getState({ uuid, channels: [channel] }, (status, state) => {
      let data = state.channels[channel];

      if (data.id) {
        let display = this.store.push(this.store.normalize('display', data));

        this.setProperties({
          display
        })
      }
    });

    return channel;
  }),

  updateTitle: observer('stream', 'uuid', function () {
    this.set('headData.title', this.stream || this.uuid);
  }),

  display: null,

  stream: oneWay('display.stream.displayName'),

  src: computed('client', 'display.playerSrc', function () {
    return this.client && this.display && this.display.playerSrc;
  })

});
