import Component from '@ember/component';
import { reads } from '@ember/object/computed';
import { inject as service } from '@ember/service';

export default Component.extend({

  store: service(),

  stream: reads('display.stream.id'),

  online: reads('display.online'),

  classNames: [
    'card'
  ],

  classNameBindings: [
    'online::bg-warning',
    'display.stream.id:bg-success'
  ],

  actions: {

    mute(muted) {
      this.display.set('muted', muted);
      this.display.save();
    },

    removeStream() {
      this.setProperties({
        channelName: null
      });

      this.action(null);

      return false;
    },

    switchStream(channelName) {
      if (channelName) {
        let logins = [
          channelName.toLowerCase()
        ]
        this.store.query('stream', { logins })
          .then((streams) => streams.firstObject)
          .then((stream) => {
            this.set('channelName', stream && stream.login || '');
            this.action(stream);
          });
      }

      return false;
    },

    remove(display) {
      display.unloadRecord();
    }
  }

});
