import DS from 'ember-data';
import { computed } from '@ember/object';
import moment from 'moment';

export default DS.Model.extend({
  startAt: DS.attr('date'),
  endAt: DS.attr('date'),
  audio: DS.attr('boolean'),
  // login: DS.attr('string'),
  display: DS.belongsTo('display', { async: false }),
  scheduled: computed('startAt', 'endAt', function () {
    return moment().isBetween(this.startAt, this.endAt);
  })
});
