import DS from 'ember-data';
import { computed } from '@ember/object';
import moment from 'moment';
import { task, timeout } from 'ember-concurrency';
import { gte, bool } from '@ember/object/computed';

export default DS.Model.extend({

  _tick: task(function * () {
    while (true) {
      yield timeout(1000);
      this.notifyPropertyChange('duration');
    }
  }).on('init'),

  channel: DS.attr('string'),

  online: DS.attr('boolean', { defaultValue: true }),

  muted: DS.attr('boolean', { defaultValue: false }),

  stream: DS.belongsTo('stream', { async: false }),

  startedAt: DS.attr('date'),

  playing: bool('stream.id'),

  streamOnline: bool('stream.online'),

  duration: computed('startedAt', function () {
    if (this.stream && this.startedAt) {
      return moment().diff(this.startedAt, 'minutes');
    }
    return 0;
  }),

  playerSrc: computed('stream.login', function () {
    let origin = window.location.origin;
    // src='https://player.twitch.tv/?allowfullscreen&player=site&channel=primevideo&origin=https%3A%2F%2Fevent-panel.event-engineering.twitch.tv'
    let settings = `player=site&controls=false&muted=false&autoplay=true&volume=1&persistUserPreferences=false&origin=${origin}`;
    if (this.stream && this.stream.login) {
      return `https://player.twitch.tv/?channel=${this.stream.login}&${settings}`;
    }
  }),

  socket: DS.attr(),

  playStream(stream, force = false) {
    if (!this.stream || this.timeup || force) {
      this.setProperties({
        stream,
        startedAt: new Date()
      });
      this.save();
    }
  },

  dispatch(stream) {
    this.socket && this.socket.publish({
      channel: this.channel,
      message: { stream }
    });
  }
});
