import DS from 'ember-data';
import { bool } from '@ember/object/computed';
import { computed } from '@ember/object';

export default DS.Model.extend({

  displayName: DS.attr(),
  login: DS.attr(),
  profileImageURL: DS.attr(),
  stream: DS.attr(),
  online: bool('stream.type'),

  display: DS.belongsTo('display', { async: false, inverse: 'stream' }),

  // display: computed('displays', function () {
  //   return this.displays.firstObject;
  // }),

  // displays: DS.belongsTo('display', { async: false, inverse: 'stream' }),

  twitchUrl: computed('login', function () {
    if (this.login) {
      return `https://www.twitch.tv/${this.login}?tt_content=${this.display.id}&tt_medium=twitchcon2018`;
    }
  }),

  displayTwitchUrl: computed('login', function () {
    if (this.login) {
      return `twitch.tv/${this.displayName}`;
    }
  })

});
