const csv = require('csv');
const moment = require('moment');
const fs = require('fs');

const getData = (filename) => {
  return new Promise((resolve) => {
    fs.readFile(filename, 'utf8', (err, data) => {
      csv.parse(data, { columns: true }, (err, data) => {
        resolve(data);
      });
    });
  })
  .then((results) => {
    return results.map((result) => {
      let date = result['Date'];
      let start_time = result['Start Time'];
      let end_time = result['End Time'];
      let start_at = moment(`${date} ${start_time}`, 'MM/DD hh:mm A').toJSON();
      let end_at = moment(`${date} ${end_time}`, 'MM/DD hh:mm A').toJSON();

      return {
        id: result['Affiliate'] || null,
        start_at,
        end_at,
        audio: /yes/i.test(result['Audio'])
      };
    });
  })
  .then((data) => data.filter(({ id, start_at, end_at }) => (id && start_at && end_at)))
}

const saveData = (filename, data) => {
  return new Promise((resolve) => {
    fs.writeFile(filename, JSON.stringify(data, null, 2), (err) => {
      if (err) return PromiseRejectionEvent(err);
      resolve(data);
    });
  });
};

getData('schedule.csv')
  .then((affiliates) => saveData('site/_data/affiliates.json', affiliates))
  .then((affiliates) => saveData('public/affiliates.json', { affiliates }))
  .then(({ affiliates }) => console.log('scheduled', { size: affiliates.length }));
