require 'aws/decider'
require './lib/s3'
require './lib/video'

require 'sinatra'
require 'sinatra/multi_route'

route :get, :post, '/enqueue_jobs' do
  Video.get_all_videos.select(&:needs_processing?).each do |video|
    puts video.final_cut_path
    AWS::Flow::start_workflow(
      "VideoProcessingWorkflow.process_videos",
      video.to_h,
      {
        domain: "VideoProcessing",
        version: "1.3",
        workflow_id: video.workflow_id,
        execution_start_to_close_timeout:  86164
      }
    )
  end
  "Done"
end
