require './lib/s3'
require 'aws/decider'
require './lib/video'
require 'open3'
require 'rev-api'
class VideoProcessingActivity
  extend AWS::Flow::Activities
  HEARTBEAT_INTERVAL = 30.0

  activity :fetch_subtitles, :transcode_video, :transcode_subtitles, :burn_in_subtitles do
    {
      version: "1.3",
      default_task_start_to_close_timeout: "21600"
    }
  end

  def fetch_subtitles(payload)
    video = Video.from_h(payload)
    transcoded_video_path = video.transcoded_video_path
    rev_client = Rev.new('ggaGNRcKh4FU4pYO1V4JKQo-3P4', 'VNgCAKIHblLRBC+4Za7WOPuRi2M=', Rev::Api::PRODUCTION_HOST)
    orders = rev_client.get_orders_by_client_ref(transcoded_video_path).orders
    if !orders.empty?
      order_number = orders.first.order_number
      order = rev_client.get_order(order_number)
      if order
        if order.status == 'Complete'
          caption = order.captions.first
          file = Tempfile.new(['subtitles', '.srt'])
          rev_client.save_attachment_content(caption.id, file.path)
          BUCKET.put_object(
            key: Video.get_raw_srt_path(video.raw_video_path),
            body: file
          )
          return
        else
          raise "Subtitles are incomplete and in #{order.status} state"
        end
      end
    else
      location = nil
      video.download(:transcoded_video_path) do |file|
        location = rev_client.upload_input(file.path, 'video/mp4')
      end
      order_request = Rev::OrderRequest.new(
        client_ref: transcoded_video_path,
        caption_options: {inputs: [{uri: location}]}
      )
      rev_client.submit_order(order_request)
      raise "Subtitles were not ordered. Now they are!"
    end
  end

  def transcode_video(payload)
    puts "transcoding video of "
    puts payload
    video = Video.from_h(payload)
    video.download(:raw_video_path) do |input_file|
      Tempfile.open(['output', '.mp4']) do |output_file|
        begin
          last_heartbeat = Time.now
          Open3.popen3(transcode_video_ffmpeg_command(input_file.path, output_file.path)) do |stdin, stdout, stderr, thread|
            while line=stderr.gets do
              puts line
              last_heartbeat = heartbeat(last_heartbeat)
            end
          end
          video.upload(:transcoded_video_path, output_file)
        ensure
          File.delete(output_file.path)
        end
      end
    end
    nil
  end

  def transcode_video_ffmpeg_command(input_path, output_path)
    command = [
        "ffmpeg",
        "-i '#{input_path}'",
        "-vcodec libx264",
        "-profile:v main",
        "-preset:v medium",
        "-r 30",
        "-g 60",
        "-keyint_min 60",
        "-sc_threshold 0",
        "-b:v 3000k",
        "-minrate 3000k",
        "-maxrate 3000k",
        "-bufsize 3000k",
        '-filter:v scale="iw*min(1920/iw\,1080/ih):ih*min(1920/iw\,1080/ih), pad=1920:1080:(1920-iw*min(1920/iw\,1080/ih))/2:(1080-ih*min(1920/iw\,1080/ih))/2"',
        "-pix_fmt yuv420p",
        "-sws_flags lanczos+accurate_rnd",
        "-acodec aac",
        "-b:a 96k",
        "-ar 48000",
        "-ac 2",
        "-y",
        output_path
    ].join(" ")
  end

  def transcode_subtitles(payload)
    puts "transcoding subtitles of "
    puts payload
    video = Video.from_h(payload)
    video.download(:raw_subtitle_path) do |f|
      Tempfile.open(['output', '.srt']) do |output_file|
        begin
          last_heartbeat = Time.now
          Open3.popen3(transcode_subtitles_pycaption_command(f.path, output_file.path)) do |stdin, stdout, stderr, thread|
            while line=stderr.gets do
              puts line
              last_heartbeat = heartbeat(last_heartbeat)
            end
          end
          video.upload(:transcoded_subtitle_path, output_file)
        ensure
          File.delete(output_file.path)
        end
      end
    end
    nil
  end

  def transcode_subtitles_pycaption_command(input_path, output_path)
    "pycaption #{input_path} --srt > #{output_path}"
  end

  def burn_in_subtitles(payload)
    puts "burning in subtitles of "
    puts payload
    video = Video.from_h(payload)
    Tempfile.open(['output', '.mp4']) do |output_file|
      last_heartbeat = Time.now
      video.download(:transcoded_subtitle_path) do |subtitles|
        video.download(:transcoded_video_path) do |video_input|
          begin
            Open3.popen3(burn_in_subtitles_ffmpeg_command(video_input.path, subtitles.path, output_file.path)) do |stdin, stdout, stderr, thread|
              while line=stderr.gets do
                puts line
                last_heartbeat = heartbeat(last_heartbeat)
              end
            end
          video.upload(:final_cut_path, output_file)
          ensure
            File.delete(output_file.path)
          end
        end
      end
    end
    nil
  end

  def burn_in_subtitles_ffmpeg_command(video_input_path, subtitle_path, output_path)
    command = [
        "ffmpeg",
        "-i '#{video_input_path}'",
        "-f mp4",
        "-vf subtitles='#{subtitle_path}'",
        "-y",
        output_path
    ].join(" ")
  end

  def heartbeat(last_heartbeat_time)
    if(Time.now - last_heartbeat_time > HEARTBEAT_INTERVAL)
      # activity_execution_context.record_activity_heartbeat(nil.to_s)
      Time.now
    else
      last_heartbeat_time
    end
  end
end
