require 'aws/decider'
require './lib/s3'
require './lib/video'


Video.get_all_videos.select do |video|
  video.needs_processing?
end.each do |video|
  begin
    puts AWS::Flow::start_workflow(
      "VideoProcessingWorkflow.process_videos",
      video.to_h,
      {
        domain: "VideoProcessing",
        version: "1.3",
        workflow_id: video.workflow_id,
        execution_start_to_close_timeout:  86164
      }
    )
  rescue
  end
end
