require 'flow/activities'
require 'lib/s3'
require 'lib/video'

class VideoProcessingWorkflow
  extend AWS::Flow::Workflows

  workflow :process_videos do
    {
      version: "1.3"
    }
  end

  activity_client(:client) { { from_class: "VideoProcessingActivity" } }

  def process_videos(payload)
    futures = []
    puts "transcoding video" if first_run?
    wait_for_all([client.send_async(:transcode_video, payload)]) if !payload[:has_transcoded_video]
    puts "creating subtitles" if first_run?
    wait_for_all([client.send_async(:create_subtitles, payload)]) if !payload[:raw_subtitle_path] && !payload[:has_transcoded_subtitles]
    payload[:raw_subtitle_path] ||= Video.get_raw_srt_path(payload[:raw_video_path])
    puts "transcode subtitles" if first_run?
    wait_for_all([client.send_async(:transcode_subtitles, payload)]) if !payload[:has_transcoded_subtitles]
    puts "burn in subtitles" if first_run?
    wait_for_all([client.send_async(:burn_in_subtitles, payload)])
  end

  def first_run?
    decision_context.workflow_clock.replaying
  end
end
