import React, { Component } from 'react';
import { desktopCapturer } from 'electron';
import { spawn } from 'child_process';
import toBuffer from 'blob-to-buffer';
import styles from './Home.css';

const FRAME_RATE = 30;
const VIDEO_BIT_RATE = 1500 * 1000;
const VIDEO_BIT_RATE_STRING = "1500k";
const CANVAS_HEIGHT = 720;
const CANVAS_WIDTH = 1280;
const STREAM_KEY = process.env.STREAM_KEY;

const WEB_CAM_RESOLUTIONS = [
    // { width: 1920, height: 1080 },
    { width: 1280, height: 720 },
    { width: 960, height: 720 },
    { width: 640, height: 360 },
    { width: 640, height: 480 },
    { width: 320, height: 240 },
    { width: 320, height: 180 }
];



export default class Home extends Component {

  constructor(props) {
    super(props);
    this.state = {
      videoDevices: [],
    };
    this.bootStrapVideoSources();
  }

  componentDidMount() {
    // this.state.backingCanvas = document.createElement('canvas');
    // this.state.backingCanvas.height = CANVAS_HEIGHT
    // this.state.backingCanvas.width = CANVAS_WIDTH
    // this.state.backingCanvas.height = 0;
    // this.state.backingCanvas.width = 0;
    this.state.canvas = document.getElementsByTagName('canvas')[0];
    this.state.backingCanvas = this.state.canvas;
    this.state.backingContext = this.state.backingCanvas.getContext('2d');

    this.state.context = this.state.canvas.getContext('2d');
    this.state.videoStream = this.state.canvas.captureStream(FRAME_RATE);
    window.requestAnimationFrame(this.paintCanvas.bind(this));
  }

  bootStrapVideoSources() {
    navigator.mediaDevices.enumerateDevices().then((devices) =>{
      const mic = devices.find((d) => d.label === 'Built-in Microphone')
      navigator.mediaDevices.getUserMedia({audio: {mandatory: {sourceId: mic.deviceId}}}).then((stream) => {
        this.setState({mic: stream})
      });
      return Promise.all(devices.filter((d) => d.kind === 'videoinput').map((d) =>
      WEB_CAM_RESOLUTIONS.reduce((accum, res) =>
        accum.catch(() => navigator.mediaDevices.getUserMedia(
          {
            video: {
              mandatory: {
                sourceId: d.deviceId,
                minWidth: res.width,
                maxWidth: res.width,
                minHeight: res.height,
                maxHeight: res.height,
                maxFrameRate: FRAME_RATE
              }
            }
          }
        )
      ), Promise.reject())
      ))}).then((streams) => {
      const videoDevices = streams.map((stream) => {
        const element = document.createElement('video');
        element.src = URL.createObjectURL(stream);
        this.setState({ videoDevices: this.state.videoDevices.concat([{ type: 'webcam', url: URL.createObjectURL(stream), stream, element }]) });
      });
    }).then(() =>
      desktopCapturer.getSources({ types: ['screen'] }, (_, sources) => {
        sources.reduce((promise, source) => {
          return promise.then(() =>
          navigator.mediaDevices.getUserMedia({
            audio: false,
            video: {
              mandatory: {
                chromeMediaSource: 'desktop',
                chromeMediaSourceId: source.id,
                minWidth: 1280,
                maxWidth: 1280,
                minHeight: 720,
                maxHeight: 720
              }
            }
          }).then((stream) =>{
            const element = document.createElement('video');
            element.src = URL.createObjectURL(stream);
            this.setState({ videoDevices: this.state.videoDevices.concat([{ type: 'screen', screenNumber: parseInt(source.name.slice(7), 10), url: URL.createObjectURL(stream), element, stream }])})
          })
          )
        }, Promise.resolve());
      })
    ).catch((err) => console.log(err));
  }

  paintCanvas() {

      this.state.videoDevices.forEach((vd, idx) => {
        this.state.backingContext.drawImage(vd.element, CANVAS_WIDTH/4 * idx, 0, CANVAS_WIDTH/4, CANVAS_HEIGHT/4);
      });
      // this.state.context.putImageData(this.state.backingContext.getImageData(0,0,CANVAS_WIDTH,CANVAS_HEIGHT), 0, 0);
      window.requestAnimationFrame(this.paintCanvas.bind(this));
    // setTimeout(() => {
    // })
  }


  ffmpeg() {
    let args = [
      // "-thread_queue_size", "512",
                // "-f", "webm",
               "-i", "pipe:0",
              //  "-thread_queue_size", "512",
               "-i", "pipe:1",
              //  "-i", "test2.mp4",
               "-c:a", "aac",
               "-b:a", "128k",
               "-ar", "44100",
               "-ac", "2",
               "-y",
               "-c:v", "libopenh264",
               "-threads", "0",
               "-keyint_min", "2",
              //  "-sc_threshold", "0",
               "-g", FRAME_RATE * 2,
               "-b", VIDEO_BIT_RATE_STRING,
               "-minrate", VIDEO_BIT_RATE_STRING,
               "-maxrate", VIDEO_BIT_RATE_STRING,
               "-bufsize", "6000k",
               "-r", `${FRAME_RATE}`,
               "-pix_fmt", "yuv420p",
               "-f", "flv", "rtmp://live.twitch.tv/app/" + STREAM_KEY];
              //  "-f",            "flv",  "test2.flv"];
        let ffmpeg = spawn('ffmpeg', args);
    // window.data = '';
    // ffmpeg.stdout
    //   .on('data', function(chunk) { data += chunk; })
    //   .on('end', function() { console.log('result', data); });

    window.err = '';
    ffmpeg.stderr
      .on('data', function(chunk) { err += chunk; console.log('' + chunk)})
      .on('end', function() { console.log('error', err);});
    ffmpeg.stdin.setEncoding('utf-8');
    return ffmpeg;
  }
  record() {
    let ffmpeg = this.ffmpeg()
    let videoRecorder = new MediaRecorder(this.state.videoStream, {
      // audioBitsPerSecond : 128000,
      videoBitsPerSecond : VIDEO_BIT_RATE,
      mimeType : 'video/webm; codecs="vp8"'
    });
    videoRecorder.start(1000/FRAME_RATE);
    let videoPromise = Promise.resolve()
    videoRecorder.ondataavailable = (a) => {
      videoPromise = videoPromise.then(() => {
        toBuffer(a.data, (err, buffer) => {
            ffmpeg.stdin.write(buffer)
        });
      });
    }

    let audioRecorder = new MediaRecorder(this.state.mic, {
          audioBitsPerSecond : 128000,
          mimeType : 'audio/webm'
        });
    audioRecorder.start(1000/FRAME_RATE);

    let audioPromise = Promise.resolve()
    audioRecorder.ondataavailable = (a) => {
      audioPromise = audioPromise.then(() => {
        toBuffer(a.data, (err, buffer) => {
          ffmpeg.stdout.write(buffer);
        })
      })
    }

    setTimeout(() => {
      console.log("mission complete")
      videoRecorder.stop()
      audioRecorder.stop()
      ffmpeg.stdin.end()
      ffmpeg.stdout.end()
    }, 200000);
  }


  render() {
    return (
      <div>
        <button onClick={this.record.bind(this)}></button>
        <canvas height={CANVAS_HEIGHT} width={CANVAS_WIDTH} className={styles.canvas}></canvas>
        <img src={this.state.imageURL}></img>
      </div>
    );
  }
}
