# This file is responsible for configuring your application
# and its dependencies with the aid of the Mix.Config module.
#
# This configuration file is loaded before any dependency and
# is restricted to this project.
use Mix.Config

# General application configuration
config :ad_gen,
  ecto_repos: [AdGen.Repo]

# Configures the endpoint
config :ad_gen, AdGen.Endpoint,
  url: [host: "localhost"],
  secret_key_base: "Z0Ks1mW8gmH2G7R63EWe9n+PSGDC2i+M5WOLZeJXjzxC1KOI94auceojgR9COY4j",
  render_errors: [view: AdGen.ErrorView, accepts: ~w(html json)],
  pubsub: [name: AdGen.PubSub,
           adapter: Phoenix.PubSub.PG2]

# Configures Elixir's Logger
config :logger, :console,
  format: "$time $metadata[$level] $message\n",
  metadata: [:request_id]

# Import environment specific config. This must remain at the bottom
# of this file so it overrides the configuration defined above.
import_config "#{Mix.env}.exs"
