defmodule AdGen.Rechat do
  alias Experimental.Flow
  use HTTPoison.Base
  @client_id "jzkbprff40iqj646a697cyrvl0zt2m6"
  def process_url(url) do
    "https://rechat.twitch.tv/rechat-messages?" <> url
  end

  def process_response_body(body) do
    body
    |> Poison.decode!
    |> Enum.into(%{})
  end

  def get_chat_messages_per_second(vod_id) do
    with %{"errors" => [%{"detail" =>  error_message}]} <- get!("start=0&video_id=v#{vod_id}", %{"Client-ID" => @client_id}).body,
         {start_time, _}    <- String.split(error_message, " ") |> Enum.at(4) |> Integer.parse,
         {end_time, _}      <- String.split(error_message, " ") |> Enum.at(6) |> Integer.parse
    do
      msgs = start_time..end_time
      |> Flow.from_enumerable()
      |> Flow.filter(&(rem(&1,30) == 0))
      |> Flow.flat_map(&(get_chat_messages(vod_id, &1)))
      |> Flow.partition(Flow.Window.global, hash:  fn msg, stages ->  {msg, :erlang.phash2(round((msg |> Map.get("attributes") |> Map.get("timestamp")) / 1000) , stages)}  end )
      |> Flow.reduce(fn -> %{} end, fn message, acc ->
        ts = round((message |> Map.get("attributes") |> Map.get("timestamp")) / 1000 )
        Map.update(acc, ts, 1, & &1 + 1)
      end)
      |> Enum.to_list
      {start_time, end_time, msgs}
    end
  end

  def find_hypest([], _time_range), do: []
  def find_hypest(msgs, time_range \\ 30) do
    Enum.max_by([
      Enum.take(msgs, time_range),
      find_hypest(Enum.drop(msgs, 1), time_range)
    ],
    fn msgs ->
      case msgs do
        [] -> 0
        msgs -> hype_measure(msgs)
      end
    end)
  end

  def hype_measure(msgs) do
    msgs
    |> Enum.with_index
    |> Enum.reduce(0, fn({{ts, count}, idx}, accum) ->  accum + (count * idx) end)
  end

  def get_hype_moment_url(channel, vod_id) do
    with {start_time, end_time, msgs} <- get_chat_messages_per_second(vod_id),
         [{offset_ts, _count} | _rest]<- find_hypest(msgs, 30),
         offset                       <- offset_ts - start_time,
         url                          <- "https://www.twitch.tv/#{channel}/v/#{vod_id}?t=#{offset}s"
    do
        url
    end
  end

  def get_chat_messages(vod_id, start_time) do
    get!("start=#{start_time}&video_id=v#{vod_id}", %{"Client-ID" => @client_id}).body |> Map.get("data")
  end
end
#  {start_time, end_time, msgs} =  AdGen.Rechat.get_chat_messages_per_second(90888495) ;AdGen.Rechat.find_hypest(msgs, 30)
# msgs |> Enum.group_by(&( round((Map.get(&1, "attributes") |> Map.get("timestamp")) /1000) )) |> Enum.map(fn({k,v})-> {k, Enum.count(v)} end) |> Enum.sort_by(fn({k,v})-> v end) |> Enum.reverse
