# Changelog

## v0.12.2

* Fix a bug where we failed miserably with a "no process" error when extracting
  translations without having the `:gettext` compiler run

## v0.12.1

* Ensure the gettext application is started before running mix tasks

## v0.12.0

* Drop support for Elixir 1.1 and require ~> 1.2
* Add `:compiler_po_wildcard` to explicitly choose the po files that are tracked by the compiler
* Allow the developer to configure what happens when there are missing bindings in the translation. The default has been changed to log and return the incomplete string instead of raising
* Move the configuration for the `:gettext` application to compile-time config
  in `project/0` in `mix.exs` (under the `:gettext` key, with configuration
  options `:excluded_refs_from_purging`, `:compiler_po_wildcard` and `:fuzzy_threshold`)
* Show the file name in syntax errors when running `mix gettext.extract` and `mix gettext.merge`
* Don't print tokens as Erlang terms in syntax error when running `mix gettext.extract` and `mix gettext.merge`
* Allow duplicate interpolation keys
* Raise when the domain is not a binary at compile-time
* Fix many dialyzer warnings
* No longer traverse directories given to `gettext.merge` recursively (from now on `gettext.merge` expect specific locale directories)
* Reenable the "compile" task in `mix gettext.extract`
* Ensure translations are tracked to the proper child app when using umbrella apps

## v0.11.0

* Polish so many docs!
* Make an error in `Gettext.put_locale/2` clearer
* Pluralize `x_Y` locales as `x`, but fail with
  `Gettext.Plural.UnknownLocaleError` for any other unknown locale
* Add a `Gettext.Backend` behaviour (automatically implemented if a module
  calls `use Gettext`)
* Allow whitelisting of references via the `:excluded_refs_from_purging` option
  in the `:gettext` application config

## v0.10.0

* Emit warnings when the domain passed to one of the `*gettext` macros has
  slashes in it (as we don't support domains in subdirectories).
* Discard dangling comments when parsing/dumping PO(T) files (dangling comments
  are comments that are not followed by a transaction they can be attached to).
* Updated informative comments for newly generated PO/POT files.

## v0.9.0

* Strip `##` comments from POT files when they're being merged into PO files;
  these comments are comments meant to be generated by tools or directed at
  developers (so they have no use for translators in PO files).
* Add informative comments at the top of newly generated PO/POT files.
* Add `Gettext.known_locales/1`
* Fix a bug with PO parsing when the PO file starts with a
  [BOM](https://en.wikipedia.org/wiki/Byte_order_mark) character (which broke
  the parser, now a warning is issued).

## v0.8.0

* Fix a bug with the `*gettext` macros, which raised an error when given
  compile-time strings in the form of `~s`/`~S` sigils.
* Create missing locale directories (e.g., `en/LC_MESSAGES`) when running the
  `gettext.merge` Mix task.
* Fallback to default translations (i.e., the `msgid`) when the `msgstr` (or one
  or more `msgstr` strings for plural translations) is empty.

## v0.7.0

* When dumping PO files, dump as many references as possible on one line,
  wrapping at the 80th column
* Parse multiple references in the same reference comment
* Remove `Gettext.locale/0-1` and `Gettext.with_locale/2` in favour of
  `Gettext.get_locale/1`, `Gettext.put_locale/2`, and `Gettext.with_locale/3`
  which now work by setting/getting the locale on a per-backend basis (instead
  of a global one)
* Remove the `:default_locale` config option for the `:gettext` application in
  favour of configuring the `:default_locale` for backends tied to their
  `:otp_app` (e.g., `config :my_app, MyApp.Gettext, default_locale: "pt_BR"`)

## v0.6.1

* Fix a bug with the `mix gettext.merge` task that was failing in Elixir v1.1.1
  because `0.5 in 0..1` returns `false` with it

## v0.6.0

* Add a `:flags` field to the `Gettext.PO.Translation` and
  `Gettext.PO.PluralTranslation` structs
* Add support for fuzzy matching translations in `gettext.merge` and
  `gettext.extract --merge`
* Add the `:fuzzy_threshold` configuration option for the `:gettext` application

## v0.5.0

* Initial release
