defmodule Aggregator.Mixfile do
  use Mix.Project

  def project do
    [app: :aggregator,
     version: "0.0.1",
     elixir: "~> 1.2",
     elixirc_paths: elixirc_paths(Mix.env),
     compilers: [:phoenix, :gettext] ++ Mix.compilers,
     build_embedded: Mix.env == :prod,
     start_permanent: Mix.env == :prod,
     deps: deps()]
  end

  # Configuration for the OTP application.
  #
  # Type `mix help compile.app` for more information.
  def application do
    [mod: {Aggregator, []},
     applications: [:phoenix, :phoenix_pubsub, :cowboy, :logger, :gettext, :gen_stage,
      :ex_aws, :hackney, :poison]]
  end

  # Specifies which paths to compile per environment.
  defp elixirc_paths(:test), do: ["lib", "web", "test/support"]
  defp elixirc_paths(_),     do: ["lib", "web"]

  # Specifies your project dependencies.
  #
  # Type `mix help deps` for examples and options.
  defp deps do
    [
     {:ex_aws, "~> 1.1.0"},
     {:configparser_ex, "~> 0.2.1"},
     {:phoenix, "~> 1.2.1"},
     {:phoenix_pubsub, "~> 1.0"},
     {:gettext, "~> 0.11"},
     {:cowboy, "~> 1.0"},
     {:gen_stage, "~> 0.4"},
     {:httpoison, "~> 0.10.0"},
     {:flow, "~> 0.11"},
     {:cronex, "~> 0.2"}]
  end
end
