defmodule Aggregator.AggregatorController do
  use Aggregator.Web, :controller
  alias Aggregator.Aggregation

  def show(conn, %{"id" => aggregate} = params) do
    limit = Map.get(params, "limit", "100")
    {limit,_} = Integer.parse(limit)

    offset = Map.get(params, "offset", "0")
    {offset,_} = Integer.parse(offset)

    languages = Map.get(params, "broadcaster_language", "")

    sort = Map.get(params, "sort", "viewers")
    order = Map.get(params, "order", "desc")

    render(conn, "show.json", aggregate: Aggregation.fetch(aggregate, limit, offset, sort, order, languages))
  end
end
