defmodule Aggregator.AggregatorView do
  use Aggregator.Web, :view
  def render("show.json", %{aggregate: nil}) do
    %{error: "not found"}
  end

  def render("show.json", %{aggregate: aggregate}) do
    %{aggregate: render_one(aggregate, Aggregator.AggregatorView, "aggregate.json")}
  end

  def render("aggregate.json", %{aggregator: aggregate}) do
    %{
      game: aggregate.game,
      _total: aggregate.total,
      streams: render_many(aggregate.streams, Aggregator.StreamView, "stream.json"),
      communities: render_many(aggregate.communities, Aggregator.CommunityView, "community.json")
    }
  end
end
