defmodule MappingToDsl do
  defmacro run(routes) do
    for route <- routes do
      quote do
        match unquote(route).route do
          conn = var!(conn)
          headers = conn.req_headers |> Enum.reject(fn({name, _val}) -> name in ["x-twitch-scopes", "accept-encoding", "x-twitch-user"] end)
          # TODO: readd accept-encoding
          scopes = fetch_scopes(conn)
          user = fetch_user(scopes)
          rack_req = %Rackla.Request{
            url: unquote(route).url <> conn.request_path <> "?" <> Plug.Conn.Query.encode(conn.params),
            method: conn.method,
            body: Poison.encode!(conn.params),
            headers: headers ++ [{"x-twitch-scopes", scopes}, {"x-twitch-user", user}]
          }
          |> request(full: true)
          |> Rackla.collect

          resp = rack_req.body
          |> Rackla.just
          |> response(json: true, compress: true, status: rack_req.status)
        end
      end
    end
  end
end
