# checkStreamLive
Lambda function to check if streams are live
Written in Node v4.3

## Object format to monitor streams
```js
const channelsToCheck = [{
    channel: 'bobross',                                      // stream to monitor
    startMonitor: 'Thu Oct 27 2016 11:59:00 GMT-0700 (PDT)', // date to being monitoring
    endMonitor: 'Thu Oct 31 2016 11:59:00 GMT-0700 (PDT)',   // date to end monitoring
}, {
    channel: 'food',
    startMonitor: 'Thu Oct 27 2016 11:59:00 GMT-0700 (PDT)',
    endMonitor: 'Thu Oct 31 2016 11:59:00 GMT-0700 (PDT)',
}];
```

### Parameters for frequency of check
``` js
const minDownLimit = 5;                // minutes stream is down before posting to pager duty
const secDownLimit = minDownLimit * 60;
const msDownLimit = secDownLimit * 1000;

const minCheckInterval = 1;              // at least once every minCheckInterval minutes check if stream is still down
const msCheckInterval = minCheckInterval * 60 * 1000;
```

#### Publish to AWS Lambda
In terminal:
```
./publish.sh
```
you may have to give execute permissions to publish.sh by `chmod +x publish.sh`
