'use strict';
const https = require('https');
// comment for aws-cli
const channelsToCheck = [{
    channel: 'bobross',
    startMonitor: 'Oct 29 2016 9:00:00 GMT-0700 (PDT)',
    endMonitor: 'Nov 6 2016 11:59:00 GMT-0700 (PDT)',
}, {
    channel: 'food',
    startMonitor: 0,
    endMonitor: 'Oct 31 9999',
}, {
    channel: 'twitchpresents',
    startMonitor: 'Mar 14 2017 12:30:33 GMT-0700 (PDT)',
    endMonitor: 'Mar 28 2017 12:30:33 GMT-0700 (PDT)'
}, {
    channel: 'cosmos',
    startMonitor: 'Apr 27 2017 12:00:00 GMT-0700 (PDT)',
    endMonitor: 'Apr 28 2017 13:56:00 GMT-0700 (PDT)'
}, {
    channel: 'misterrogers',
    startMonitor: 'May 15 2017 12:00:00 GMT-0700 (PDT)',
    endMonitor: 'Jun 03 2017 13:45:00 GMT-0700 (PDT)'
}, {
    channel: 'shoutfactorytv',
    startMonitor: 'Jun 26 2017 11:00:00 GMT-0700 (PDT)',
    endMonitor: 'Jul 03 2017 10:30:00 GMT-0700 (PDT)'
}, {
    channel: 'twitchpresents', // Crunchyroll
    startMonitor: 'Jul 27 2017 15:00:00 GMT-0700 (PDT)',
    endMonitor: 'Aug 01 2017 15:30:00 GMT-0700 (PDT)'
}, {
    channel: 'twitchpresents', // RWBY1 day 1
    startMonitor: 'Oct 09 2017 11:00:00 GMT-0700 (PDT)',
    endMonitor: 'Oct 09 2017 20:00:00 GMT-0700 (PDT)'
}, {
    channel: 'twitchpresents', // RWBY2 day 2
    startMonitor: 'Oct 10 2017 11:00:00 GMT-0700 (PDT)',
    endMonitor: 'Oct 10 2017 20:40:00 GMT-0700 (PDT)'
}, {
    channel: 'twitchpresents', // RWBY3 day 3
    startMonitor: 'Oct 11 2017 11:00:00 GMT-0700 (PDT)',
    endMonitor: 'Oct 11 2017 22:45:00 GMT-0700 (PDT)'
}, {
    channel: 'twitchpresents', // RWBY4 day 4
    startMonitor: 'Oct 12 2017 11:00:00 GMT-0700 (PDT)',
    endMonitor: 'Oct 12 2017 21:18:00 GMT-0700 (PDT)'
}, {
    channel: 'twitchpresents', // RWBY1-4 day 5
    startMonitor: 'Oct 13 2017 11:00:00 GMT-0700 (PDT)',
    endMonitor: 'Oct 14 2017 09:40:00 GMT-0700 (PDT)'
}, {
    channel: 'twitchpresents', // Yugioh DM
    startMonitor: 'Oct 23 2017 12:00:00 GMT-0700 (PDT)',
    endMonitor: 'Nov 7 2017 12:41:00 GMT-0800 (PST)'
}, {
    channel: 'bobross', // Bobross marathon 2017
    startMonitor: 'Oct 27 2017 19:00:00 GMT-0700 (PDT)',
    endMonitor: 'Nov 4 2017 9:50:00 GMT-0700 (PDT)'
}, {
    channel: 'twitchpresents', // Yugioh DM rerun
    startMonitor: 'Nov 29 2017 20:00:00 GMT-0800 (PST)',
    endMonitor: 'Dec 11 2017 00:05:00 GMT-0800 (PST)'
}, {
    channel: 'twitchpresents2', // Digimon
    startMonitor: 'Nov 30 2017 20:00:00 GMT-0800 (PST)',
    endMonitor: 'Dec 13 2017 09:18:00 GMT-0800 (PST)'
}];
const minDownLimit = 2; // minutes, lambda functions have max 5 min before timeout
const secDownLimit = minDownLimit * 60; // seconds
const msDownLimit = secDownLimit * 1000; //ms

const minCheckInterval = 0.75; // minutes
const msCheckInterval = minCheckInterval * 60 * 1000; // ms

function alertWahba(channel, msTimeDown, startDownTime) {
  let minDown = msTimeDown / 1000 / 60;
  let date = new Date(startDownTime);
  let data = {
      "service_key": "2a435d292ea340b6a0755213c9333d90",
      "incident_key": `${channel}_down`,
      "event_type": "trigger",
      "description": `${channel} has been down for the past ${minDown} minutes`,
      "client": "CheckIfLiveLambda",
      "client_url": `https://twitch.tv/${channel}`,
      "details": {
        "helpful metadata": `${channel} went down at ${date.toLocaleString()}, exceeding ${minDownLimit} min limit`
      }
    }

  data = JSON.stringify(data);

  let options = {
    hostname: 'events.pagerduty.com',
    method: 'POST',
    path: '/generic/2010-04-15/create_event.json'
  }

  console.log(`POST TO PAGER DUTY: start Down Time: ${date.toLocaleString()}, for ${msTimeDown}, on channel: ${channel}`);

  let req = https.request(options, res => {
    res.setEncoding('utf8');
    res.on('data', data => console.log('Reply from POST to pagerduty:', data));
  });

  req.on('error', err => console.log(err, 'Problem posting to pagerduty'));

  req.write(data);
  req.end();
}

function checkChannel(channel, cb, startDownTime, intervalCheck) {
  let headers = {
      Accept: 'application/vnd.twitchtv.v3+json',
  };
  headers['client-id'] = 'jzkbprff40iqj646a697cyrvl0zt2m6';

  let options = {
      hostname: 'api.twitch.tv',
      method: 'GET',
      path: `/kraken/streams/${channel}`,
      headers
  };

  let channelResponse = https.request(options, res => {
      res.on('data', resData => {
         let streamData = JSON.parse(resData.toString('utf8'));

         if(!streamData.stream) { // stream is down
            startDownTime = startDownTime || Date.now();
            console.log('Stream is down:', channel, ' . It has been down for ', (Date.now()-startDownTime)/1000/60, 'mins');
             // begin interval check
             if(!intervalCheck) {
               intervalCheck = setInterval( () => {
                 checkChannel(channel, cb, startDownTime, intervalCheck);
               }, msCheckInterval);
             }

             let msTimeDown = Date.now() - startDownTime;

             if(msTimeDown > msDownLimit) {
               console.log('THE STREAM IS DOWN!!!!!! RED ALERT!! CHANNEL:', channel);
               alertWahba(channel, msTimeDown, startDownTime);
               clearInterval(intervalCheck);
               cb(null, channel + ' STREAM IS DOWN');
             }
         } else {
           clearInterval(intervalCheck);
         }
      });
  });

  channelResponse.end();
}

exports.handler = (event, context, callback) => {
    channelsToCheck.forEach(channelToCheck => {
      let startMonitor = new Date(channelToCheck.startMonitor).valueOf(); // ms
      let endMonitor = new Date(channelToCheck.endMonitor).valueOf(); // ms
      var now = Date.now(); // ms

      if(now > startMonitor && now < endMonitor) {
        let checkResponse = checkChannel(channelToCheck.channel, callback);
      }
      return;
    });
};
