'use strict';
const https = require('https');

const GAMES = ['Twitch Presents', 'Always On'];

const tpWhitelist = {
  149747285: 'twitchpresents',
  148018215: 'misterrogers',
  148018320: 'cosmos',
  105458682: 'bobross',
  112866535: 'food',
  176416093: 'clipstv',
  71068671: 'failarmy',
  174174299: 'thepetcollective',
  178374763: 'ign1',
  92025399: 'baeble',
  177460246: 'baeble_music',
  49161847: 'machinima',
  7832442: 'rifftrax',
  125986831: 'twitchclips',
  142128642: 'shoutfactorytv',
  178115381: 'collidervideo',
  176513803: 'contv',
  179294473: 'thealtchannel',
  2712547: 'shudder',
  2429325: 'stadium',
  179846360: 'nbagleague',
  179943101: 'nbagleaguecostreams',
  182953678: 'twitchpresents2',
  141062634: 'elevensports',
  182747332: 'buzzr',
  157161991: 'choppertown',
};

const WHISPER_MESSAGE = function(directory) {
  return `Hello! The game directory "${directory}" is reserved for all premium content streamed by Twitch and its official content partners. \
  Please stream to a different game. Thank you!`
}

var avoidDoubleWhisper = {};

let setGameToNull = function(stream, game) {
  let channel = stream.channel;
  if(!GAMES.includes(stream.game)) return;
  if(tpWhitelist[channel._id]) return;

  let options = {
    hostname: 'api.twitch.tv',
    path: `/kraken/channels/${channel._id}`,
    method: 'PUT'
  };

  const req = https.request(options, (res) => {
    res.setEncoding('utf8');
    let body = '';
    res.on('data', (data) => { body += data });
    res.on('end', () => {
      let fullResponse = JSON.parse(body);
      whisperChannel(channel._id, game);
      console.log(`Set Channel ${channel.display_name}, (ID: ${channel._id}) to null game`)
    });
  });

  req.setHeader('Client-ID','jzkbprff40iqj646a697cyrvl0zt2m6');
  req.setHeader('Accept', 'application/vnd.twitchtv.v5+json');
  req.setHeader('Content-Type', 'application/json');
  req.setHeader('Authorization', 'OAuth m08kj6cwda5myipfsr4alxgv4ntqb0');

  req.write(JSON.stringify({
    channel: {
      game: ""
    }
  }));

  req.on('error', (err) => console.log(`Error Setting game to null for channel ${channel._id}:`, err));
  req.end();
}


let whitelistGame = function(game) {
  const tpOptions = {
    hostname: 'api.twitch.tv',
    path: `/kraken/streams/?game=${encodeURI(game)}`,
    method: 'GET'
  };

  const req = https.request(tpOptions, (res) => {
    let body = ''
    res.setEncoding('utf8');

    res.on('data', (data) => { body += data });

    res.on('end', () => {
      let fullResponse = JSON.parse(body);
      let streams = fullResponse.streams;
      streams.forEach((stream) => {
        setGameToNull(stream, game)
      });
    });
  });

  req.setHeader('Client-ID','jzkbprff40iqj646a697cyrvl0zt2m6');

  req.on('error', (err) => console.log(`Error getting streams for ${game}:`, err));
  req.write(JSON.stringify({}));
  req.end();
};

let whisperChannel = function(channelID, gameName) {
  if(avoidDoubleWhisper[channelID]) return;
  avoidDoubleWhisper[channelID] = true;

  const options = {
    hostname: 'im.twitch.tv',
    path: '/v1/messages',
    method: 'POST'
  }

  const req = https.request(options, (res) => {
    let body = ''
    res.setEncoding('utf8');
    res.on('data', (data) => { body += data });
    res.on('end', () => {
      let fullResponse = JSON.parse(body);
      if(fullResponse.error) console.error(fullResponse.error)
    });
  })

  req.setHeader('Authorization', 'OAuth m08kj6cwda5myipfsr4alxgv4ntqb0');
  req.setHeader('Content-Type', 'application/json');

  req.write(JSON.stringify({
    body: WHISPER_MESSAGE(gameName),
    from_id: 138522981,
    to_id: channelID
  }));

  req.on('error', (err) => console.log(`Error whispering streams (${channelID}) for game #{gameName}:`, err));
  req.end();
}

exports.handler = (event, context, callback) => {
  GAMES.forEach((game) => {
    setTimeout(() => { whitelistGame(game) }, 30*1000);
    whitelistGame(game);
  })
};
