package netutil

import (
	"net"
	"time"
)

// BuildDialer returns a function with the same signature as net.Dial, for use
// in http.Transport in particular. It sets timeouts both for the connection
// and for reading/writing.
func BuildDialer(dialTimeout, dataTimeout *time.Duration) func(nw, addr string) (net.Conn, error) {
	return func(nw, addr string) (net.Conn, error) {
		var c net.Conn
		var err error
		if *dialTimeout != 0 {
			c, err = net.DialTimeout(nw, addr, *dialTimeout)
		} else {
			c, err = net.Dial(nw, addr)
		}
		if err != nil {
			return nil, err
		}

		if *dataTimeout != 0 {
			err = c.SetDeadline(time.Now().Add(*dataTimeout))
			if err != nil {
				c.Close()
				return nil, err
			}
		}
		return c, nil
	}
}
