package netutil

import (
	"bytes"
	"io/ioutil"
	"net/http"
	"net/url"
)

// DoPost makes a POST request to http://hostPort+path with the provided body,
// returning the body of the response.
func DoPost(client *http.Client, headers http.Header, hostPort, path string, body []byte) ([]byte, error) {
	url := (&url.URL{
		Scheme: "http",
		Host:   hostPort,
		Path:   path,
	}).String()

	req, err := http.NewRequest("POST", url, nil)
	if err != nil {
		return nil, err
	}

	req.Body = NopCloser{bytes.NewReader(body)}
	req.ContentLength = int64(len(body))
	if headers != nil {
		for k, v := range headers {
			req.Header[k] = v
		}
	}

	resp, err := client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}

	return respBody, nil
}
