package sse

import (
	"net/http"
)

type Source struct {
	l       *Looper
	Backlog int
}

func NewHandler(l *Looper) *Source {
	return &Source{
		l:       l,
		Backlog: 100,
	}
}

func (T *Source) ServeHTTP(w http.ResponseWriter, r *http.Request) {
	backlog := T.Backlog
	if backlog < 1 {
		backlog = 1
	}
	callback := make(chan string, backlog)
	T.register(callback)
	defer T.unregister(callback)

	fl, ok := w.(http.Flusher)
	if !ok {
		http.Error(w, "can't flush", http.StatusInternalServerError)
		return
	}

	// W3C requires this MIME type
	w.Header().Set("Content-Type", "text/event-stream")
	// tell nginx to not buffer
	w.Header().Set("X-Accel-Buffering", "no")
	// start sending the data!
	w.WriteHeader(http.StatusOK)
	fl.Flush()

	for msg := range callback {
		_, err := w.Write([]byte(msg))
		if err != nil {
			return
		}
		fl.Flush()
	}
}

func (T *Source) register(callback chan string) {
	T.l.Register(callback)
}

func (T *Source) unregister(callback chan string) {
	go T.l.Unregister(callback)
	for _ = range callback {
		// discard
	}
}
