package sse

import (
	"strings"
	"time"
)

type Registration struct {
	callback chan<- string
	add      bool
}

type Looper struct {
	clients map[chan<- string]bool
	reg     chan *Registration
	pub     chan string
}

func NewLooper() (l *Looper) {
	l = new(Looper)
	l.clients = make(map[chan<- string]bool)
	l.reg = make(chan *Registration)
	l.pub = make(chan string)
	return
}

func (T *Looper) Loop() {
	for {
		T.crank()
	}
}

func (T *Looper) crank() {
	select {
	case r := <-T.reg:
		if r.add {
			T.clients[r.callback] = true
		} else {
			delete(T.clients, r.callback)
			close(r.callback)
		}
	case msg := <-T.pub:
		for client := range T.clients {
			select {
			case client <- msg:
				// send message to listener
			default:
				// don't block
			}
		}
	}
}

func (T *Looper) SendPings(d time.Duration) {
	tick := time.Tick(d)
	for {
		<-tick
		T.SendRaw(":ping\n")
	}
}

func (T *Looper) SendRaw(msg string) {
	T.pub <- msg
}

func (T *Looper) SendEvent(event, data string) {
	T.SendRaw(prefix("event", event) + prefix("data", data) + "\n")
}

func (T *Looper) Register(callback chan<- string) {
	T.reg <- &Registration{callback, true}
}

func (T *Looper) Unregister(callback chan<- string) {
	T.reg <- &Registration{callback, false}
}

func prefix(prefix, body string) string {
	lines := strings.Split(body, "\n")
	for i, line := range lines {
		lines[i] = prefix + ": " + line + "\n"
	}
	return strings.Join(lines, "")
}
