package api

import "errors"

// ErrOauthTokenNotProvided is generated when the oauth_token is not provided
var ErrOauthTokenNotProvided = errors.New("Oauth Token not provided")

// ErrUserNotVerified is generated when the oauth_token is not provided
var ErrUserNotVerified = errors.New("User email not verified")

// ErrUserNotAuthorized is generated when the user is not authroized
var ErrUserNotAuthorized = errors.New("User is not authorized")

// ErrBannerNotUploaded is generated when the banner could not upload
var ErrBannerNotUploaded = errors.New("Banner not provided")

// ErrWrongBannerDimensions is generated when the banner has the wrong dimensions
var ErrWrongBannerDimensions = errors.New("Banner must be 1600 x 900")

// ErrPreviewImageNotUploaded is generated when the banner url is not valid
var ErrPreviewImageNotUploaded = errors.New("Preview image not provided")

// ErrCommunityNotProvided is generated when community is not provided
var ErrCommunityNotProvided = errors.New("Community not provided")

// ErrCommunityInvalidName is generated when community name is invalid
var ErrCommunityInvalidName = errors.New("Invalid Community name")

// ErrCommunityDoesNotExist is generated when community is not provided
var ErrCommunityDoesNotExist = errors.New("Community does not exist")

// ErrGameNotSupported is generated when community name is invalid
var ErrGameNotSupported = errors.New("Game does not have communities")

// ErrStreamsNotFound is generated when community name is invalid
var ErrStreamsNotFound = errors.New("No Streams found")

// ErrUserNotProvided is generated when community is invalid
var ErrUserNotProvided = errors.New("User not provided")

// ErrGameNotProvided is generated when game is invalid
var ErrGameNotProvided = errors.New("Game not provided")

// ErrUserGamesNotProvided is generated when game is invalid
var ErrUserGamesNotProvided = errors.New("UserGame not provided")

// ErrPromotedChannelNotFound is generated when the promoted channel is not found
var ErrPromotedChannelNotFound = errors.New("Promoted Channel not found")

// ErrRequestInvalid is generated when the request is invalid and nothing more specific is applicable
var ErrRequestInvalid = errors.New("Request invalid")
