package main

import (
	"fmt"
	"time"

	"code.justin.tv/creative/communities/api"
	"code.justin.tv/creative/communities/lib"
	"code.justin.tv/creative/communities/lib/orm"
	"code.justin.tv/creative/communities/models"
)

func main() {
	db, err := orm.Client()
	if err != nil {
		panic(err)
	}
	defer util.CloseAndReport(db)
	for gameName := range api.AllowedGames {
		if gameName != "all" {
			if gameName == "creative" { // delete this once we kill api.AllowedGames
				gameName = "Creative"
			}
			game := models.Game{}
			err := db.FirstOrCreate(&game, models.Game{Name: gameName}).Error
			if err != nil {
				panic(err)
			}
		}
	}

	creative := models.Game{}
	err = db.First(&creative, models.Game{Name: "Creative"}).Error
	if err != nil {
		panic(err)
	}
	communities := []string{
		"animation",
		"cosplay",
		"drawing",
		"food",
		"gamedev",
		"glass",
		"illustration",
		"leatherwork",
		"music",
		"painting",
		"pixelart",
		"programming",
		"sewing",
		"designdolls",
		"graphite",
		"perler",
		"vector",
		"figurines",
		"woodworking",
		"writing",
		"sketch",
		"anime",
		"watercolor",
		"jewelry",
		"electronics",
		"3dmodeling",
		"crossstitch",
		"sculpting",
		"editing",
		"artstation",
		"bodyart",
		"fiberarts",
		"metalworking",
		"papercraft",
		"design",
		"digitalillustration",
		"comedy",
		"magic",
		"dance",
		"voiceacting",
		"theater",
		"robotics",
		"chainmaille",
		"brewing",
		"virink",
		"automotive",
		"comics",
		"pcbuilding",
		"makeup",
	}
	for _, communityName := range communities {
		community := models.Community{}
		err := db.FirstOrCreate(&community, models.Community{
			GameID: creative.ID,
			Name:   communityName,
		}).Error
		if err != nil {
			panic(err)
		}
	}

	communitiesToDelete := []string{
		"overwatchcontest",
		"createforkids",
		"cosplaycontest",
		"talentshow",
		"inktober",
		"bobrossmarathon",
		"lastguardiancontestentry",
	}
	for _, communityName := range communitiesToDelete {
		community := models.Community{}
		err = db.First(&community, models.Community{Name: communityName}).Error
		if err != nil {
			fmt.Println(communityName, "is already deleted or does not exist")
			continue
		}
		updates := map[string]interface{}{
			"deleted_at": time.Now(),
		}
		if err = community.UpdateAttributes(db, updates); err != nil {
			panic(err)
		}
	}

}
