CREATE TABLE user_communities(
  id int NOT NULL PRIMARY KEY,
  user_id int NOT NULL,
  game_id int,
  community_id int NOT NULL,
  updated_at timestamp with time zone NOT NULL,
  created_at timestamp with time zone NOT NULL
);

CREATE SEQUENCE user_communities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE ONLY user_communities ALTER COLUMN id SET DEFAULT nextval('user_communities_id_seq'::regclass);


CREATE UNIQUE INDEX user_and_game_user_communities_idx on user_communities (user_id, game_id);
CREATE INDEX community_user_communities_idx on user_communities (community_id);
CREATE INDEX updated_at_user_communities_idx on user_communities (updated_at);
