CREATE TABLE communities(
  id int NOT NULL PRIMARY KEY,
  game_id int NOT NULL,
  name text NOT NULL,
  updated_at timestamp with time zone NOT NULL,
  created_at timestamp with time zone NOT NULL
);


CREATE SEQUENCE communities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE ONLY communities ALTER COLUMN id SET DEFAULT nextval('communities_id_seq'::regclass);


CREATE INDEX game_id_communities_idx on communities (game_id);
CREATE INDEX name_communities_idx on communities (name);
