freeStyleJob('creative-communities') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'creative/communities', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'manta -v -f build.json'
    saveDeployArtifact 'creative/communities', '.manta'
  }
}

freeStyleJob('creative-communities-deploy') {
  using 'TEMPLATE-deploy-aws'
  steps {
    shell 'courier deploy --repo creative/communities --dir /opt/twitch/communities'
  }
}
 
