package orm

import (
	"code.justin.tv/creative/communities/settings"

	"github.com/stvp/rollbar"

	"github.com/jinzhu/gorm"
	// pq imports db
	_ "github.com/jinzhu/gorm/dialects/postgres"
)

var cachedClient *gorm.DB

// Client is Gorm client wrapper
func Client() (*gorm.DB, error) {
	if cachedClient != nil {
		return cachedClient, nil
	}
	ormClient, err := gorm.Open("postgres", settings.Resolve("postgresURL"))
	if err != nil {
		rollbar.Error(rollbar.ERR, err)
	}
	if settings.Resolve("debug") == "true" {
		ormClient.LogMode(true)
	}
	cachedClient = ormClient
	return ormClient, err
}
