package owlclient

import (
	"code.justin.tv/common/twitchhttp"
	"code.justin.tv/creative/communities/settings"
	"code.justin.tv/web/owl/client"
	"github.com/stvp/rollbar"
)

var owlClient *owl.Client

// Client is Owl client wrapper
func Client() (*owl.Client, error) {
	owlClient, err := owl.NewClient(twitchhttp.ClientConf{
		Host: settings.Resolve("owlURL"),
	})
	if err != nil {
		rollbar.Error(rollbar.ERR, err)
		return nil, err
	}
	return owlClient, nil
}
