package redisclient

import (
	"strconv"

	"github.com/stvp/rollbar"

	"gopkg.in/redis.v3"

	"code.justin.tv/creative/communities/settings"
)

var redisLoaded bool
var redisClient redis.Client

// Client is Redis client wrapper
func Client() (*redis.Client, error) {
	if redisLoaded {
		return &redisClient, nil
	}

	redisLoaded = true

	var db, err = strconv.Atoi(settings.Resolve("redisDb"))
	if err != nil {
		rollbar.Error(rollbar.ERR, err)
		return nil, err
	}
	options := redis.Options{
		Addr:     settings.Resolve("redisAddress"),
		Password: settings.Resolve("redisPassword"), // no password set
		DB:       int64(db),                         // use default DB
	}
	redisClient = *redis.NewClient(&options)
	return &redisClient, nil
}

// FlushRedis Flushes redis
func FlushRedis() error {
	rdb, err := Client()
	if err != nil {
		return err
	}
	return rdb.FlushAll().Err()
}
