package s3client

import (
	"code.justin.tv/creative/communities/settings"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3"
)

var s3Loaded bool
var s3Client s3.S3

// Client is S3 client wrapper
func Client() *s3.S3 {
	if s3Loaded {
		return &s3Client
	}

	svc := s3.New(session.New(&aws.Config{
		Region:      aws.String("us-west-2"),
		Credentials: credentials.NewStaticCredentials(settings.Resolve("s3Id"), settings.Resolve("s3Secret"), ""),
	}))

	return svc
}
