package smtpclient

import (
	"fmt"

	"code.justin.tv/release/smtp"
	"github.com/stvp/rollbar"
)

var smtpLoaded bool
var twitchSMTPClient TwitchSMTP

// TwitchSMTP wraps the smtp client to give it convenience methods
type TwitchSMTP struct {
	smtpClient smtp.Client
}

// Client is SMTP client wrapper
func Client() (*TwitchSMTP, error) {
	if smtpLoaded {
		return &twitchSMTPClient, nil
	}
	smtpClient, err := smtp.NewClient("smtp.internal.justin.tv", 25)
	if err != nil {
		rollbar.Error(rollbar.ERR, err)
		return nil, err
	}

	return &TwitchSMTP{smtpClient: *smtpClient}, nil
}

// SendMessage sends an email to users
func (c TwitchSMTP) SendMessage(headers map[string]string, body string) (*smtp.Message, error) {
	mail := c.smtpClient.NewMail()
	for headerName, value := range headers {
		err := mail.Header(headerName, value)
		if err != nil {
			rollbar.Error(rollbar.ERR, err)
			return nil, err
		}
	}
	fmt.Fprintf(mail, body)
	err := mail.Close()
	return mail, err
}
