package util

import (
	"time"

	"github.com/stvp/rollbar"
)

// SetPst will set the timezone to PST (without changing the date)
func SetPst(t time.Time) (*time.Time, error) {
	loc, err := time.LoadLocation("America/Los_Angeles")
	if err != nil {
		return nil, err
	}
	y, m, d := t.Date()
	H, M, S := t.Clock()
	timeInPst := time.Date(y, m, d, H, M, S, 0, loc)
	return &timeInPst, nil
}

// GetCurrentTime returns the time in PST
func GetCurrentTime() (*time.Time, error) {
	pst, err := time.LoadLocation("America/Los_Angeles")
	if err != nil {
		return nil, err
	}
	currentTime := time.Now().In(pst)
	return &currentTime, nil
}

// Closable is an interface that we want to close and log
type Closable interface {
	Close() error
}

// CloseAndReport closes then logs to rollbar if it fails
func CloseAndReport(closeable Closable) {
	err := closeable.Close()
	if err != nil {
		rollbar.Error(rollbar.WARN, err)
	}
}

// IntMin is IntMin
func IntMin(x, y int) int {
	if x < y {
		return x
	}
	return y
}

// IntMax is IntMax
func IntMax(x, y int) int {
	if x > y {
		return x
	}
	return y
}
