package main

import (
	"log"

	"github.com/jasonlvhit/gocron"
	"github.com/stvp/rollbar"

	"code.justin.tv/common/config"
	"code.justin.tv/common/twitchhttp"
	"code.justin.tv/creative/communities/api"
	"code.justin.tv/creative/communities/lib/cache"
	"code.justin.tv/creative/communities/lib/chatcache"
	"code.justin.tv/creative/communities/settings"
)

func main() {
	rollbar.Token = settings.Resolve("rollbarToken")
	rollbar.Environment = settings.Resolve("rollbarEnvironment")
	err := config.Parse()
	if err != nil {
		log.Fatal(err)
	}
	stats := config.Statsd()
	server, err := api.NewServer(stats)
	if err != nil {
		log.Fatal(err)
	}

	// Flush on boot

	// err = redisclient.FlushRedis()
	// if err != nil {
	// 	panic(err)
	// }

	go func() {
		for {
			err := chatcache.Run()
			if err != nil {
				rollbar.Error(rollbar.ERR, err)
			}
		}
	}()

	// Update Community streams every minute
	go func() {
		updateCommunityStreams()
		gocron.Every(1).Minute().Do(updateCommunityStreams)
		<-gocron.Start()
	}()

	log.Fatal(twitchhttp.ListenAndServe(server))
}

// updateCommunityStreams will update currently live streams and log errors
func updateCommunityStreams() {
	err := cache.CommunitiesFromStreams()
	if err != nil {
		rollbar.Error(rollbar.ERR, err)
	}
}
