package models

import (
	"time"

	"github.com/jinzhu/gorm"
)

// Game is a struct with the game name
type Game struct {
	ID        int
	Name      string
	UpdatedAt time.Time
	CreatedAt time.Time
}

// FindGameByName finds a game by it's case insensitive name
func FindGameByName(name string, db *gorm.DB) (*Game, error) {
	game := Game{}
	err := db.Where("lower(name) = lower(?)", name).First(&game).Error
	if err != nil {
		if err != gorm.ErrRecordNotFound {
			return nil, ErrGameNotFound
		}
		return nil, err
	}
	return &game, nil
}
