package models

import (
	"time"

	"code.justin.tv/creative/communities/lib"
)

// KrakenStream represents the streams within the kraken response
type KrakenStream struct {
	Game      string     `json:"game"`
	Viewers   int        `json:"viewers"`
	CreatedAt *time.Time `json:"created_at"`
	Channel   struct {
		Status string `json:"status"`
		ID     int    `json:"_id"`
		Name   string `json:"name"`
		Mature bool   `json:"mature"`
	} `json:"channel"`
}

// KrakenStreams is a list of KrakenStream
type KrakenStreams []KrakenStream

func (s KrakenStreams) Len() int {
	return len(s)
}
func (s KrakenStreams) Swap(i, j int) {
	s[i], s[j] = s[j], s[i]
}
func (s KrakenStreams) Less(i, j int) bool {
	return s[i].Viewers > s[j].Viewers
}

// StartedWithin will return True when provided stream stared within Duration of now
func (s KrakenStream) StartedWithin(d time.Duration) (bool, error) {
	currentTime, err := util.GetCurrentTime()
	if err != nil {
		return false, err
	}
	beforeTime := currentTime.Add(d)
	res := s.CreatedAt.After(beforeTime)
	return res, nil
}

// KrakenStreamsResponse represents the kraken response
type KrakenStreamsResponse struct {
	Streams []KrakenStream `json:"streams"`
	Total   int            `json:"_total"`
}

// KrakenStreamsSummaryResponse represents a Stream Summary response
type KrakenStreamsSummaryResponse struct {
	Channels int `json:"channels"`
	Viewers  int `json:"viewers"`
}
