package settings

import (
	"log"
	"os"

	"code.justin.tv/common/config"
)

var settingsLoaded bool

// Resolve Proxy to resolve all settings globally
func Resolve(field string) string {
	if !settingsLoaded {
		environment := os.Getenv("ENVIRONMENT")
		if environment == "" {
			environment = "production"
		}

		if environment == "development" {
			config.Register(Development)
		} else if environment == "staging" {
			config.Register(Staging)
		} else if environment == "production" {
			config.Register(Production)
		} else {
			log.Fatal("Environment:", environment, " is not supported")
		}
		settingsLoaded = true
		err := config.Parse()

		if err != nil {
			log.Fatal(err)
		}
	}
	return config.Resolve(field)
}
