resource "aws_iam_role" "app" {
  name = "${var.iam_role_name}-${var.environment}"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "app" {
  name = "${var.iam_role_name}-${var.environment}"
  roles = ["${aws_iam_role.app.name}"]
}

resource "aws_iam_policy" "AccessTwitchCreativeAssetsBucket" {
    name = "AccessTwitchCreativeAssetsBucket"
    description = "Allows a user to access twitch creative assets"
    policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
      {
          "Sid": "Stmt1459902580000",
          "Effect": "Allow",
          "Action": [
              "s3:Get*",
              "s3:List*",
              "s3:Put*",
              "s3:DeleteObject"
          ],
          "Resource": [
              "arn:aws:s3:::${var.assets_bucket}/*",
              "arn:aws:s3:::${var.assets_bucket}"
          ]
      }
  ]
}
EOF
}


resource "aws_iam_policy_attachment" "attachCreativeToProfileIAM" {
    name = "attach-to-s3-user"
    roles = ["${aws_iam_role.app.name}"]
    users = ["${aws_iam_user.s3User.name}", "laura", "web-web-uploader"]
    policy_arn = "${aws_iam_policy.AccessTwitchCreativeAssetsBucket.arn}"
}

resource "aws_iam_user" "s3User" {
  name = "s3-${var.iam_role_name}-${var.environment}"
}


resource "aws_iam_access_key" "s3Creds" {
    user = "${aws_iam_user.s3User.name}"
}
