
 resource "aws_route53_record" "communities_postgres" {
     provider = "aws.dns"
     zone_id = "${module.base.r53}"
     type = "CNAME"
     name = "${var.name}-postgres.${var.environment}.us-west2.justin.tv"
     records = ["${aws_db_instance.communities_postgres.address}"]
     ttl = "300"
 }

 resource "aws_db_subnet_group" "communities_db_subnet_group" {
     name = "communities-db-subnet-${var.environment}"
     description = "DB Subnet group"
     subnet_ids = ["${split(",", "${terraform_remote_state.account.output.service_subnets}")}"]
 }

 resource "aws_db_instance" "communities_postgres" {
     identifier = "communities-db-${var.environment}"
     allocated_storage = 32
     engine = "postgres"
     engine_version = "9.5.2"
     instance_class = "db.m4.large"
     skip_final_snapshot = false
     final_snapshot_identifier = "communities-db-final-snapshot-${var.environment}"
     port = 5432
     multi_az = true
     backup_retention_period = 7
     storage_encrypted = true
     password = "jubilantconifer"
     username = "communities"
     name = "communities_db"
     vpc_security_group_ids = ["${terraform_remote_state.account.output.twitch_subnets_sg}"]
     db_subnet_group_name = "${aws_db_subnet_group.communities_db_subnet_group.name}"
 }
