resource "terraform_remote_state" "account" {
  backend = "s3"
  config {
    bucket = "${lookup(var.account, var.environment)}"
    region = "us-west-2"
    key = "tfstate/creative/terraform/accounts/${lookup(var.account, var.environment)}"
  }
}

resource "terraform_remote_state" "asg_lambda" {
  backend = "s3"
  config {
    bucket = "${lookup(var.account, var.environment)}"
    region = "us-west-2"
    key = "tfstate/web/asg-r53-lambda/services/lambda/${lookup(var.account, var.environment)}"
  }
}
