class CommunityApplicationsController < ApplicationController
  def index
    prefix = params[:prefix] || "submit"
    keys = S3.list_objects({
      bucket: "twitch-creative-assets",
      prefix: prefix
    }).contents.map(&:key)
    @submissions = keys.map { |key| Submission.from_key(key) }
  end
  def accept
    S3.copy_object({
      acl: "public-read",
      bucket: "twitch-creative-assets",
      copy_source: "twitch-creative-assets/#{params[:key]}",
      key: "communities/#{params[:tag]}.jpg"
    })
    flash[:notice] = "Image in communities folder at https://s3-us-west-2.amazonaws.com/twitch-creative-assets/communities/#{params[:tag]}.jpg"
    redirect_to :back
  end

end
