import os
import sys
import communitybot.logger
from communitybot.settings import SETTINGS
from communitybot.bots.stream import StreamBot


def main():
    '''
    Start the Community Bot who will listen for commands and respond
    accordingly to the action.
    '''
    communitybot.logger.basicConfig(
        SETTINGS['environment'],
        rollbar=SETTINGS['rollbar'],
        slack=SETTINGS['slack'])
    try:
        env_channel = os.environ.get('CHANNEL')
        print "ENV_CHANNEL", env_channel
        if env_channel is None:
            raise Exception("Bot environment not provided")
        bot_settings = SETTINGS['bots'][env_channel]
        bot = StreamBot(
            channels=[bot_settings['channel']],
            nickname=bot_settings['nickname'],
            password='oauth:%s' % bot_settings['oauth_token'],
            server=SETTINGS['server'],
            port=SETTINGS['port'])
        bot.start()
    except Exception:
        communitybot.logger.exception(sys.exc_info())


if __name__ == '__main__':
    main()
