import requests
import json
import base64


def _encode(msg):
    return base64.urlsafe_b64encode(json.dumps(msg)).replace('=', '%3D')


def track(event, properties):
    msg = {"event": event, "properties": properties}
    encoded_msg = _encode(msg)
    data = 'data=%s' % encoded_msg
    url = "https://spade.twitch.tv/?%s" % data
    return requests.get(url)
