# -*- coding: utf-8 -*-

import math
import datetime
import string
from functools import wraps


def thirds(l):
    '''
    Splits the provided list into into a list of 3 options 1/3 in size
    '''
    if len(l) < 3:
        return zip(channels)
    chunk_length = int(math.ceil(len(l) / 3.0))
    return _chunks(l, chunk_length)


def _chunks(l, n):
    '''
    Yield successive n-sized chunks from l
    '''
    for i in range(0, len(l), n):
        yield l[i:i+n]


class throttle(object):
    '''
    Only call function once every X seconds
    '''

    def __init__(self, seconds=0):
        self.wait = datetime.timedelta(seconds=seconds)
        self.invocation_timestamps = {}

    def last_invocation(self, fn, throttle_key, new=None):
        '''
        Return timestamp of last method invocation
        '''
        if new is not None:
            self.invocation_timestamps[(fn, throttle_key)] = new
        return self.invocation_timestamps.get(
            (fn, throttle_key), datetime.datetime.now() - self.wait)

    def __call__(self, fn):
        '''
        Allow each decorated method to be called, at most,
        one time per every `self.wait` seconds
        '''
        that = self

        @wraps(fn)
        def w(*args, **kwargs):
            return that.wrapper(fn, *args, **kwargs)
        return w

    def wrapper(self, fn, *args, **kwargs):
        throttle_key = kwargs.pop("throttle_key", "")
        last_invocation = self.last_invocation(fn, throttle_key)
        now = datetime.datetime.now()
        time_since_last_call = now - last_invocation
        ignore_throttle = kwargs.pop("ignore_throttle", False)
        if time_since_last_call > self.wait or ignore_throttle:
            self.last_invocation(fn, throttle_key, now)
            return fn(*args, **kwargs)


class command_throttle(throttle):
    def wrapper(self, fn, *args, **kwargs):
        user = args[3]
        community = args[2]
        ignore_throttle = community.is_admin(user)
        throttle_key = community.name
        return super(command_throttle, self).wrapper(
            fn, *args, throttle_key=throttle_key,
            ignore_throttle=ignore_throttle, **kwargs)

BAN_WORDS = set([])

TIMEOUT_WORDS = set([
    u'aids',
    u'anal',
    u'anus',
    u'aroused',
    u'assfuck',
    u'assfucked',
    u'assfucker',
    u'asshole',
    u'autist',
    u'bdsm',
    u'bdsm',
    u'beaner',
    u'beastiality',
    u'bitch',
    u'b!tch',
    u'l3itch',
    u'blowjob',
    u'bollock',
    u'bollok',
    u'bondage',
    u'boner',
    u'boobies',
    u'boobs',
    u'bewbs',
    u'brojob',
    u'bukkake',
    u'bukkakke',
    u'bu11sh1t',
    u'bullshit',
    u'bu!!sh!t',
    u'buiishit',
    u'buttfuck',
    u'buttfucker',
    u'buttfucking',
    u'butthole',
    u'buttplug',
    u'chink',
    u'chink',
    u'clit',
    u'cl1t',
    u'cl!t',
    u'clit',
    u'cock',
    u'c0ck',
    u'cawk',
    u'cok',
    u'kawk',
    u'kock',
    u'kawk',
    u'cockblock',
    u'cockhead',
    u'cockmunch',
    u'cockmuncher',
    u'cocksucker',
    u'c0cksucker',
    u'cock-sucker',
    u'cocksucking',
    u'coon',
    u'coon',
    u'koon',
    u'creampie',
    u'cuck',
    u'cucked',
    u'cucks',
    u'cum',
    u'kum',
    u'cumming',
    u'cumm!ng',
    u'cummlng',
    u'kumming',
    u'cumshot',
    u'cumsh0t',
    u'cumsh07',
    u'cunt',
    u'cun7',
    u'cnut',
    u'kunt',
    u'cuntlicker',
    u'cuntlicking',
    u'cunts',
    u'cunts',
    u'kunts',
    u'cyberfuck',
    u'cyberfucking',
    u'dago',
    u'deepthroat',
    u'dick',
    u'dik',
    u'd!ck',
    u'd1ck',
    u'dickhead',
    u'dildo',
    u'd!ldo',
    u'dilf',
    u'dilf',
    u'd!lf',
    u'd1lf',
    u'dong',
    u'd0ng',
    u'douche',
    u'douchebag',
    u'douchefag',
    u'dyke',
    u'ejaculate',
    u'ejaculated',
    u'ejaculates',
    u'ejaculating',
    u'ejaculation',
    u'fag',
    u'f4g',
    u'faeg',
    u'faggot',
    u'fagget',
    u'f4ggot',
    u'f4gg0t',
    u'f4gg07',
    u'f4gget',
    u'f4gge7',
    u'faggit',
    u'fagg!t',
    u'fagot',
    u'faget',
    u'fagit',
    u'fags',
    u'faggs',
    u'fap',
    u'f4p',
    u'fapping',
    u'f4pping',
    u'felching',
    u'fetish',
    u'fingerfuck',
    u'fingerfucking',
    u'fingering',
    u'fistfuck',
    u'fistfucking',
    u'fisting',
    u'f!st!ng',
    u'fleshlight',
    u'fucboi',
    u'fuccboi',
    u'fnck',
    u'fuck',
    u'fvck',
    u'fûck',
    u'fuk',
    u'fück',
    u'f u c k',
    u'fcuk',
    u'feck',
    u'fuk',
    u'phuck',
    u'phuk',
    u'f.u.c.k',
    u'fuc',
    u'fucked',
    u'fucked',
    u'fucken',
    u'fucker',
    u'f u c k e r',
    u'fcuker',
    u'fucka',
    u'fuker',
    u'fukker',
    u'fuckers',
    u'fuckhead',
    u'fuckin',
    u'fuck1n',
    u'fuckln',
    u'fuck!n',
    u'fukkin',
    u'fucking',
    u'fuck1ng',
    u'fuck!ng',
    u'fucklng',
    u'fcking',
    u'fecking',
    u'fuckme',
    u'fuckme',
    u'fuckoff',
    u'fucks',
    u'fudgepacker',
    u'gangbang',
    u'gilf',
    u'g!lf',
    u'g1lf',
    u'gllf',
    u'gook',
    u'handjob',
    u'hardon',
    u'hentai',
    u'hitler',
    u'h!tler',
    u'h1tler',
    u'homo',
    u'h0m0',
    u'homos',
    u'honkey',
    u'honky',
    u'hooker',
    u'horny',
    u'incest',
    u'!ncest',
    u'lncest',
    u'1ncest',
    u'jack-off',
    u'jackoff',
    u'jailbait',
    u'jap',
    u'jerk-off',
    u'jerkoff',
    u'jew',
    u'jigaboo',
    u'jism',
    u'jizim',
    u'jizzim',
    u'jizz',
    u'j1zz',
    u'j!zz',
    u'jiz',
    u'jiz',
    u'kike',
    u'kyke',
    u'kkk',
    u'masturbate',
    u'masterbate',
    u'master-bate',
    u'masterb8',
    u'masturbating',
    u'masterbating',
    u'milf',
    u'm!lf',
    u'm1lf',
    u'mllf',
    u'|v|ilf',
    u'molest',
    u'molester',
    u'molestor',
    u'moneyshot',
    u'motherfucker',
    u'm0therfucker',
    u'mothafucka',
    u'motherfucker',
    u'motherfuckers',
    u'mothafuckin',
    u'motherfucking',
    u'mothafucking',
    u'muff',
    u'muff',
    u'muffdiver',
    u'nazi',
    u'naz!',
    u'nig',
    u'nlgga',
    u'nigga',
    u'n1gga',
    u'nigg4h',
    u'niggah',
    u'niga',
    u'ɴίģģλ',
    u'niggas',
    u'niggaz',
    u'nigger',
    u'n1gger',
    u'ⁿigger',
    u'niggger',
    u'n!gger',
    u'n|gger',
    u'ńigger',
    u'niqqer',
    u'n1qqer',
    u'n!qqer',
    u'n1gg3r',
    u'niggér',
    u'n3gg3r',
    u'niger',
    u'n|ggel2',
    u'n i g g e r',
    u'n!gg€rz',
    u'niggers',
    u'n!ggers',
    u'n i g g e r s',
    u'nigglet',
    u'nigglets',
    u'niglets',
    u'n!gglets',
    u'n!glets',
    u'niglet',
    u'n!glet',
    u'nip',
    u'nutshot',
    u'orgasm',
    u'orgy',
    u'paki',
    u'pedo',
    u'penis',
    u'p3n15',
    u'pen!s',
    u'piss',
    u'pocketpussy',
    u'poon',
    u'poontang',
    u'puntang',
    u'porn',
    u'p0rn',
    u'pron',
    u'pr0n',
    u'porno',
    u'prick',
    u'pr!ck',
    u'pussies',
    u'pussy',
    u'puzzy',
    u'pussys',
    u'queef',
    u'qweef',
    u'r4pe',
    u'rape',
    u'rap3',
    u'r@p3',
    u'r@pe',
    u'rapist',
    u'retard',
    u'retarded',
    u'schlick',
    u'shlick',
    u'schlong',
    u'semen',
    u'sex',
    u's3x',
    u'53x',
    u'shemale',
    u'shit',
    u'shlt',
    u'sh1t',
    u'sh17',
    u'sh!t',
    u's h i t',
    u'shite',
    u's.h.i.t',
    u'shitfaced',
    u'sh!tfaced',
    u'shithead',
    u'shits',
    u'shitter',
    u'shitting',
    u'sh!tt!ng',
    u'shitty',
    u'sh!tty',
    u'slave',
    u's14v3',
    u's1ave',
    u'$lave',
    u'slaves',
    u's1aves',
    u's14v3s',
    u'$laves',
    u'slut',
    u'slu7',
    u'spic',
    u'spick',
    u'splooge',
    u'spunk',
    u'strapon',
    u'threesome',
    u'3some',
    u'tits',
    u't!ts',
    u'titts',
    u'titties',
    u't!tt!es',
    u't1tt1e5',
    u't!tt!es',
    u'tittyfuck',
    u'tittyfucking',
    u'tubesteak',
    u'twat',
    u'tw4t',
    u'upskirt',
    u'vag',
    u'v4g',
    u'v@g',
    u'vagina',
    u'v@g1n4',
    u'v4g1n4',
    u'wank',
    u'wetback',
    u'whore',
    u'hoar',
    u'hoare',
    u'hoe',
    u'hore',
    u'whoar',
    u'whoare',
    u'hor',
    u'whores',
    u'wigger',
    u'wincest',
    u'w!ncest'
])


def normalize(s):
    '''
    Normalize message to ensure proper parsing for specific patterns
    '''
    return ''.join(s.split()).lower()


def has_matches(s, words):
    '''
    Return True when s contains any of the strings within words. This will
    normalize the string to ignore punctuation and spaces
    '''
    search = normalize(s)
    return any(w in search for w in words)
