# dreamer

Stream video content to Twitch 24/7.

# Getting started

You'll need to have the following installed to run

- Python 2.7
- `ffmpeg`

You'll also need to setup your config/overrides.json
It should look something like:

```
{
  "bot": {
    "irc_channels": ["#channel_name"],
    "nickname": "channel_name",
    "oauth_token": "OAUTH_TOKEN",
    "server": "irc.twitch.tv",
    "port": 6667
  },
  "stream": {
    "key" : "STREAM_KEY",
    "channel" : "channel_name",
    "oauth_token" : "OAUTH_TOKEN"
  }
}
```

# Streaming

To start a stream to Twitch API we use `ffmpeg` with `concat` which
takes a list of files that point to supported video files. `ffmpeg`
will stream the videos found in the the queue (or a list of queues)
directly to the API. Our wrapper allows logging, error handling
and tracking of the last played/current video.

```sh
APP_ENV=development python ffmpeg.py
```

`-v` can be added to make the service `verbose` and output all `ffmpeg`'s standard logs.

# Admin

There is a web admin that can be used for viewing/updating the queue of videos
that the stream will play next.

> NOTE: You can only change queues that have not been started

To run the admin use

```sh
APP_ENV=development python dreamer.py
```

# Bot

There is a chat bot that tracks allows users to ask about the channel.

To run the bot use

```sh
APP_ENV=development python bot.py
```
get an oauth token here: http://twitchapps.com/tmi/

# Logging

This project supports logging via terminal (stdout/stderr) as well as Rollbar
and Slack. To write your own logs you can:

```python
import logger
logger.basicConfig(environment='production',  # Any string for rollbar
                   rollbar='API_KEY',
                   slack='API_KEY')
# Log to stderr + rollbar
logger.log('Something unexpected', level=logger.ERROR)
# Log to stdout + rollbar
logger.log('Something interesting', level=logger.INFO)
# Log to rollbar
logger.rollbar('Something to track')
# Log to slack
logger.slack('Something we all should know')
```
