import atexit
import os
import readline
import rlcompleter
import sys

#  App imports, be sure to add to reloads below
import settings
import dreamer
import ffmpeg
import queue
import s3
import stream
import video


def r():
    '''
    Convenience reload all method
    '''
    print("reloading")
    reload(ffmpeg)
    reload(video)
    reload(dreamer)
    reload(s3)
    reload(stream)
    reload(settings)
    print("reloaded")


# change autocomplete to tab
readline.parse_and_bind("tab: complete")

historyPath = os.path.expanduser("~/.pyhistory")


def save_history(historyPath=historyPath):
    # needed because called at exit
    import readline
    readline.write_history_file(historyPath)

if os.path.exists(historyPath):
    readline.read_history_file(historyPath)

atexit.register(save_history)

# anything not deleted (sys and os) will remain in the interpreter session
del atexit, readline, rlcompleter, save_history, historyPath
