import re
import subprocess


def duration(file_path):
    '''
    Returns the duration of the video if it exists
    '''
    output = _probe(file_path)
    if output is None:
        return output
    matches = re.search(".*Duration: (.*), start:.*", output)
    if matches:
        return matches.group(1)


def playable(filepath):
    output = _probe(file_path)
    return output is not None


def _probe(filepath):
    command = [
        'ffprobe',
        filepath
    ]
    try:
        return subprocess.check_output(command, stderr=subprocess.STDOUT)
    except subprocess.CalledProcessError, e:
        return None
